/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.pmod.util;

import com.ibm.hwmca.fw.servlet.pmod.PanelModel;
import com.ibm.hwmca.fw.servlet.pmod.util.Queue;
import com.ibm.hwmca.fw.util.FastStack;
import com.ibm.hwmca.fw.util.StringUtils;
import com.ibm.hwmca.fw.util.Trace;

public class TransactionLock {
    private static final String TRACE_MASKT = "XPMTLCKT";
    private static final String TRACE_MASKF = "XPMTLCKF";
    private static final String TRACE_MASKD = "XPMTLCKD";
    private Queue lockWaiterQueue = new Queue();
    private FastStack lockHolders = new FastStack();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseTransactionLock() {
        this.trace("releaseTransactionLock()");
        TransactionLock transactionLock = this;
        synchronized (transactionLock) {
            LockCaller holder;
            LockCaller lockCaller = holder = this.lockHolders.empty() ? null : (LockCaller)this.lockHolders.peek();
            if (holder != null && holder.holder == Thread.currentThread()) {
                if (--holder.holdCount > 0) {
                    this.trace("releaseTransactionLock() lock still held by thread, count reduced to " + holder.holdCount + ".");
                    return;
                }
                this.lockHolders.pop();
                if (this.lockHolders.empty()) {
                    if (!this.lockWaiterQueue.empty()) {
                        this.trace("releaseTransactionLock() handing lock to waiting thread.");
                        LockCaller newHolder = (LockCaller)this.lockWaiterQueue.pull();
                        newHolder.holdCount = 1;
                        this.lockHolders.push(newHolder);
                        newHolder.release();
                    }
                } else {
                    this.trace("releaseTransactionLock() lock returns to cooperating thread.");
                }
            } else {
                this.trace("releaseTransactionLock() called by non owning thread.");
                this.trace("\tCurrent thread is '" + Thread.currentThread().getName() + "'");
                this.trace("\tLock owner is '" + (this.lockHolders.empty() ? "*nobody*" : this.lockHolders.peek().toString()) + "'");
                throw new RuntimeException("releaseTransactionLock() called by a non owning thread.");
            }
            this.trace(PanelModel.getTraceArgSB().append("releaseTransactionLock() returns, current holder:").append(this.lockHolders.empty() ? "*nobody*" : this.lockHolders.peek().toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void yieldTransactionLock(Thread friend) {
        this.trace("yieldTransactionLock()");
        TransactionLock transactionLock = this;
        synchronized (transactionLock) {
            LockCaller holder;
            LockCaller lockCaller = holder = this.lockHolders.empty() ? null : (LockCaller)this.lockHolders.peek();
            if (holder == null || holder.holder != Thread.currentThread()) {
                this.trace("yieldTransactionLock() called by non owning thread.");
                this.trace("\tCurrent thread is '" + Thread.currentThread().getName() + "'");
                this.trace("\tLock owner is '" + (this.lockHolders.empty() ? "*nobody*" : this.lockHolders.peek().toString()) + "'");
                throw new RuntimeException("yieldTransactionLock() called by a non owning thread.");
            }
            LockCaller newHolder = new LockCaller(friend);
            newHolder.holdCount = 1;
            this.lockHolders.push(newHolder);
            this.trace(PanelModel.getTraceArgSB().append("Thread: '").append(Thread.currentThread().getName()).append("' yields to: '").append(friend.getName()).append("'"));
            this.trace(PanelModel.getTraceArgSB().append("yieldTransactionLock() returns, current holder:").append(this.lockHolders.empty() ? "*nobody*" : this.lockHolders.peek().toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revokeTransactionLock() {
        this.trace("revokeTransactionLock()");
        TransactionLock transactionLock = this;
        synchronized (transactionLock) {
            LockCaller holder;
            LockCaller lockCaller = holder = this.lockHolders.empty() ? null : (LockCaller)this.lockHolders.peek();
            if (holder != null) {
                if (holder.holdCount != 1) {
                    this.trace("revokeTransactionLock() current holder can not be unlocked, multiple locks present.");
                    throw new RuntimeException("revokeTransactionLock() current holder can not be unlocked, multiple locks present.");
                }
            } else {
                this.trace("revokeTransactionLock() nobody's holding a lock!  Can't revoke!.");
                throw new RuntimeException("revokeTransactionLock() nobody's holding the lock.");
            }
            this.lockHolders.pop();
            this.trace(PanelModel.getTraceArgSB().append("revokeTransactionLock() revoked ('").append(holder.holder.getName()).append("')"));
            this.trace(PanelModel.getTraceArgSB().append("revokeTransactionLock() returns, current holder:").append(this.lockHolders.empty() ? "*nobody*" : this.lockHolders.peek().toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTransactionLockHolder(Thread thread) {
        this.trace(" isTransactionLockHolder()");
        TransactionLock transactionLock = this;
        synchronized (transactionLock) {
            LockCaller holder;
            LockCaller lockCaller = holder = this.lockHolders.empty() ? null : (LockCaller)this.lockHolders.peek();
            return holder != null && holder.holder == thread;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void obtainTransactionLock() {
        this.trace(" obtainTransactionLock()");
        TransactionLock transactionLock = this;
        synchronized (transactionLock) {
            if (this.lockHolders.empty()) {
                LockCaller holder = new LockCaller(Thread.currentThread());
                holder.holdCount = 1;
                this.lockHolders.push(holder);
                this.trace(PanelModel.getTraceArgSB().append(" obtainTransactionLock() returns, no contention, current holder:").append(this.lockHolders.empty() ? "*nobody*" : this.lockHolders.peek().toString()));
                return;
            }
            LockCaller holder = (LockCaller)this.lockHolders.peek();
            if (holder.holder == Thread.currentThread()) {
                ++holder.holdCount;
                this.trace(PanelModel.getTraceArgSB().append(" obtainTransactionLock() returns, recursive, current holder:").append(this.lockHolders.empty() ? "*nobody*" : this.lockHolders.peek().toString()));
                return;
            }
            this.trace(PanelModel.getTraceArgSB().append(" obtainTransactionLock() must wait... (holder=").append(holder).append(")."));
            LockCaller wc = new LockCaller(Thread.currentThread());
            this.lockWaiterQueue.push(wc);
            wc.block();
            this.trace(PanelModel.getTraceArgSB().append(" obtainTransactionLock() returns, current holder:").append(this.lockHolders.empty() ? "*nobody*" : this.lockHolders.peek().toString()));
        }
    }

    public void trace(Object msg) {
        StringBuffer buf = StringUtils.getThreadLocalStringBuffer();
        buf.append("[TLock] ").append(msg);
        Trace.trace(TRACE_MASKF, buf.toString());
    }

    public void trace(String mask, Object msg) {
        StringBuffer buf = StringUtils.getThreadLocalStringBuffer();
        buf.append("[TLock] ").append(msg);
        Trace.trace(mask, buf.toString());
    }

    private class LockCaller {
        boolean release = false;
        Thread holder = null;
        int holdCount = 0;

        LockCaller(Thread holder) {
            this.holder = holder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void release() {
            TransactionLock transactionLock = TransactionLock.this;
            synchronized (transactionLock) {
                this.release = true;
                TransactionLock.this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void block() {
            TransactionLock transactionLock = TransactionLock.this;
            synchronized (transactionLock) {
                while (!this.release) {
                    try {
                        TransactionLock.this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        public String toString() {
            return "'" + this.holder.getName() + "' count=" + this.holdCount;
        }
    }
}

